package com.bizunited.platform.titan.starter.repository;

import com.bizunited.platform.titan.entity.ProcessInstanceAttachmentEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Set;

/**
 * 流程实例附件的持久化接口
 * @Author: Paul Chan
 * @Date: 2019-06-10 14:07
 */
@Repository("ProcessInstanceAttachmentRepository")
public interface ProcessInstanceAttachmentRepository extends
    JpaRepository<ProcessInstanceAttachmentEntity, String>,
    JpaSpecificationExecutor<ProcessInstanceAttachmentEntity> {

  /**
   * 根据ID查询详情
   * @param id
   * @return
   */
  @Query("select pia from ProcessInstanceAttachmentEntity pia " +
      " inner join fetch pia.processInstance pi where pia.id = :id")
  ProcessInstanceAttachmentEntity findDetailById(@Param("id") String id);

  /**
   * 根据流程实例ID查询附件信息
   * @param processInstanceId
   * @return
   */
  @Query("select pia from ProcessInstanceAttachmentEntity pia " +
      " left join fetch pia.createUser cu" +
      " inner join fetch pia.processInstance pi where pi.processInstanceId = :processInstanceId")
  Set<ProcessInstanceAttachmentEntity> findDetailsByProcessInstanceId(@Param("processInstanceId") String processInstanceId);
}
