package com.bizunited.platform.titan.starter.repository;

import com.bizunited.platform.titan.entity.ProcessInstanceMsgEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 流程实例消息持久化的接口
 * @Author: Paul Chan
 * @Date: 2019-05-23 14:52
 */
@Repository("ProcessInstanceMsgRepository")
public interface ProcessInstanceMsgRepository extends
    JpaRepository<ProcessInstanceMsgEntity, String>,
    JpaSpecificationExecutor<ProcessInstanceMsgEntity> {

  /**
   * 根据流程实例ID查询留言记录
   * @param processInstanceId
   * @return
   */
  @Query("select pim from ProcessInstanceMsgEntity pim" +
      " inner join fetch pim.sendUser pimsu" +
      " inner join pim.processInstance pi" +
      " where pim.parent is null and pi.processInstanceId = :processInstanceId order by pim.createTime asc")
  List<ProcessInstanceMsgEntity> findByProcessInstanceId(@Param("processInstanceId") String processInstanceId);

}
