package com.bizunited.platform.titan.starter.repository;

import com.bizunited.platform.titan.entity.ProcessInstanceOperateRecordEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 流程操作记录持久化的接口
 * @Author: Paul Chan
 * @Date: 2019-05-23 14:45
 */
@Repository("ProcessInstanceOperateRecordRepository")
public interface ProcessInstanceOperateRecordRepository extends
    JpaRepository<ProcessInstanceOperateRecordEntity, String>,
    JpaSpecificationExecutor<ProcessInstanceOperateRecordEntity> {


  /**
   * 根据流程实例、最后提交时间和按钮查询记录
   * @param processInstanceId
   * @param latestSubmitTime
   * @param btns
   * @return
   */
  @Query("select pior from ProcessInstanceOperateRecordEntity pior inner join pior.processInstance piorpi " +
      "where piorpi.processInstanceId = :processInstanceId " +
      "and pior.createTime >= :latestSubmitTime " +
      "and pior.operation in :btns")
  List<ProcessInstanceOperateRecordEntity> findByProcessInstanceIdAndLatestSubmitTimeAndBtns(@Param("processInstanceId") String processInstanceId,
                                                                                             @Param("latestSubmitTime") Date latestSubmitTime,
                                                                                             @Param("btns") String[] btns);

  /**
   * 根据流程实例ID查询操作记录
   * @param processInstanceId
   * @return
   */
  @Query("select pior from ProcessInstanceOperateRecordEntity pior inner join pior.processInstance piorpi " +
      " inner join fetch pior.operator pioro" +
      " inner join fetch pior.processTemplateNode piorpt" +
      " where piorpi.processInstanceId = :processInstanceId order by pior.createTime asc")
  Set<ProcessInstanceOperateRecordEntity> findDetailsByProcessInstanceId(@Param("processInstanceId") String processInstanceId);

  /**
   * 根据流程实例ID和节点ID查询操作记录
   * @param processInstanceId
   * @param processNodeId
   * @return
   */
  @Query("select pior from ProcessInstanceOperateRecordEntity pior inner join pior.processInstance piorpi " +
      " inner join fetch pior.operator pioro" +
      " inner join pior.processTemplateNode piorpt" +
      " where piorpi.processInstanceId = :processInstanceId" +
      " and piorpt.processNodeId = :processNodeId order by pior.createTime asc")
  Set<ProcessInstanceOperateRecordEntity> findByProcessInstanceIdAndProcessNodeId(@Param("processInstanceId")String processInstanceId, @Param("processNodeId") String processNodeId);

  /**
   * 根据任务ID、用户ID、按钮统计
   * @param taskId
   * @param userId
   * @param btns
   * @return
   */
  @Query("select count(*) from ProcessInstanceOperateRecordEntity pior inner join pior.operator pioro" +
      " where pior.taskId = :taskId and pioro.id = :userId and pior.operation in :btns")
  Long countByTaskIdAndUserIdAndBtns(@Param("taskId") String taskId, @Param("userId") String userId, @Param("btns") String[] btns);

  /**
   * 根据用户ID和按钮获取操作记录
   * @param taskId
   * @param btns
   * @return
   */
  @Query("select pior from ProcessInstanceOperateRecordEntity pior inner join fetch pior.operator pioro" +
      " where pior.taskId = :taskId and pior.operation in :btns")
  Set<ProcessInstanceOperateRecordEntity> findByTaskIdAndBtns(@Param("taskId") String taskId, @Param("btns") String[] btns);
}
