package com.bizunited.platform.titan.starter.repository;

import com.bizunited.platform.titan.entity.ProcessInstanceEntity;
import com.bizunited.platform.titan.entity.ProcessTemplateNodeEntity;
import com.bizunited.platform.titan.starter.repository.internal.ProcessInstanceRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Set;

/**
 * 流程实例持久化接口服务
 * @Author: Paul Chan
 * @Date: 2019-05-22 19:14
 */
@Repository("ProcessInstanceRepository")
public interface ProcessInstanceRepository extends
    JpaRepository<ProcessInstanceEntity, String>,
    JpaSpecificationExecutor<ProcessInstanceEntity>,
    ProcessInstanceRepositoryCustom {

  /**
   * 根据流程实例ID查询流程实例信息
   * @param processInstanceId
   * @return
   */
  ProcessInstanceEntity findByProcessInstanceId(String processInstanceId);

  /**
   * 根据流程实例ID查询流程详情
   * @param processInstanceId
   * @return
   */
  @Query("select pi from ProcessInstanceEntity pi inner join fetch pi.processTemplate pt" +
      " inner join fetch pi.applicantUser piau" +
      " left join fetch pi.latestAssignment pila" +
      " left join fetch pi.latestNode piln" +
      " left join fetch pt.createUser ptcu" +
      " left join fetch pt.modifyUser ptmu" +
      " where pi.processInstanceId = :processInstanceId")
  ProcessInstanceEntity findDetailsByProcessInstanceId(@Param("processInstanceId") String processInstanceId);

  /**
   * 根据流程实例ID查询实例当前的任务节点
   * @param processInstanceId
   * @return
   */
  @Query("select picn from ProcessInstanceEntity pi " +
      " inner join pi.currentNodes picn " +
      " left join fetch picn.processTemplateNodePermission ptnp" +
      " left join fetch picn.processTemplateNodeMulti ptnm" +
      " left join fetch  ptnp.createUser cu" +
      " left join fetch  ptnp.modifyUser mu" +
      " where pi.processInstanceId = :processInstanceId")
  Set<ProcessTemplateNodeEntity> findCurrentNodesByProcessInstanceId(@Param("processInstanceId") String processInstanceId);
}
