package com.bizunited.platform.titan.starter.repository;

import com.bizunited.platform.titan.entity.ProcessListenerEntity;
import com.bizunited.platform.titan.starter.repository.internal.ProcessListenerRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-15 20:10
 * @Description: 流程监听器持久化接口
 */
@Repository("ProcessListenerRepository")
public interface ProcessListenerRepository extends
    JpaRepository<ProcessListenerEntity, String>,
    JpaSpecificationExecutor<ProcessListenerEntity>,
    ProcessListenerRepositoryCustom {


  /**
   * 根据用户名统计
   * @param name
   * @return
   */
  @Query("select count(*) from ProcessListenerEntity pl where pl.name = :name")
  Long countByName(@Param("name") String name);

  /**
   * 根据用户名统计，排除ID
   * @param name
   * @param id
   * @return
   */
  @Query("select count(*) from ProcessListenerEntity pl where pl.name = :name and pl.id <> :id")
  Long countByNameExclusiveId(@Param("name") String name, @Param("id") String id);

}
