package com.bizunited.platform.titan.starter.repository;

import com.bizunited.platform.titan.entity.ProcessTemplateListenerEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Set;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-14 14:14
 * @Description: 流程模版监听器的持久化接口
 */
@Repository("ProcessTemplateListenerRepository")
public interface ProcessTemplateListenerRepository extends
    JpaRepository<ProcessTemplateListenerEntity, String>,
    JpaSpecificationExecutor<ProcessTemplateListenerEntity>{


  /**
   * 根据流程模版ID查询列表
   * @param processTemplateId
   * @return
   */
  @Query("select ptl from ProcessTemplateListenerEntity ptl inner join ptl.processTemplate pt where pt.id = :processTemplateId")
  List<ProcessTemplateListenerEntity> findByProcessTemplateId(@Param("processTemplateId") String processTemplateId);

  /**
   * 根据流程模版ID查询详情
   * @param processTemplateId
   * @return
   */
  @Query("select ptl from ProcessTemplateListenerEntity ptl inner join ptl.processTemplate pt " +
      " left join fetch ptl.processListener ptlpl" +
      " left join fetch ptl.script ptls" +
      " left join fetch ptls.createUser ptlscu" +
      " left join fetch ptls.modifyUser ptlsmu" +
      " where pt.id = :processTemplateId")
  Set<ProcessTemplateListenerEntity> findDetailsByProcessTemplateId(@Param("processTemplateId") String processTemplateId);

  @Query("select ptl from ProcessTemplateListenerEntity ptl inner join ptl.processTemplate pt " +
      " left join fetch ptl.processListener ptlpl" +
      " left join fetch ptl.script ptls" +
      " where pt.processDefinitionId = :processDefinitionId" +
      " and ptl.targetId = :targetId" +
      " and ptlpl.listenerEvent = :event" +
      " order by ptl.createTime asc")
  List<ProcessTemplateListenerEntity> findDetailsByProcessDefinitionIdAndTargetIdAndEvent(@Param("processDefinitionId") String processDefinitionId,
                                                                                          @Param("targetId") String targetId, @Param("event") String event);
}
