package com.bizunited.platform.titan.starter.repository;

import com.bizunited.platform.titan.entity.ProcessTemplateNodeAssignmentEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-13 18:53
 * @Description: 流程模版节点审批人服务的之久化接口
 */
@Repository("ProcessTemplateNodeAssignmentRepository")
public interface ProcessTemplateNodeAssignmentRepository extends
    JpaRepository<ProcessTemplateNodeAssignmentEntity, String>,
    JpaSpecificationExecutor<ProcessTemplateNodeAssignmentEntity> {

  /**
   * 根据流程节点ID获取流程节点审批人信息
   * @param processTemplateNodeId
   * @return
   */
  @Query("select ptna from ProcessTemplateNodeAssignmentEntity ptna inner join ptna.processTemplateNode ptn where ptn.id = :processTemplateNodeId")
  ProcessTemplateNodeAssignmentEntity findByProcessTemplateNodeId(@Param("processTemplateNodeId") String processTemplateNodeId);

  /**
   * 根据流程定义ID和节点ID获取节点审批人配置
   * @param processDefinitionId
   * @param processNodeId 流程节点定义ID
   * @return
   */
  @Query("select ptna from ProcessTemplateNodeAssignmentEntity ptna inner join ptna.processTemplateNode ptn" +
      " inner join ptn.processTemplate pt" +
      " left join fetch ptna.processListener pl" +
      " left join fetch ptna.script s" +
      " where pt.processDefinitionId = :processDefinitionId and ptn.processNodeId = :processNodeId")
  ProcessTemplateNodeAssignmentEntity findDetailsByProcessDefinitionIdAndProcessNodeId(@Param("processDefinitionId") String processDefinitionId, @Param("processNodeId") String processNodeId);
}
