package com.bizunited.platform.titan.starter.repository;

import com.bizunited.platform.titan.entity.ProcessTemplateNodeMultiEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * 流程模版节点会签属性的持久化接口
 * @Author: Paul Chan
 * @Date: 2019-05-31 10:37
 */
@Repository("ProcessTemplateNodeMultiRepository")
public interface ProcessTemplateNodeMultiRepository extends
    JpaRepository<ProcessTemplateNodeMultiEntity, String>,
    JpaSpecificationExecutor<ProcessTemplateNodeMultiEntity> {

  /**
   * 根据流程节点ID查询会签属性
   * @param templateNodeId
   * @return
   */
  @Query("select ptnm from ProcessTemplateNodeMultiEntity ptnm inner join ptnm.processTemplateNode ptn where ptn.id = :templateNodeId")
  ProcessTemplateNodeMultiEntity findByTemplateNodeId(@Param("templateNodeId") String templateNodeId);

}
