package com.bizunited.platform.titan.starter.repository;

import com.bizunited.platform.titan.entity.ProcessTemplateNodePermissionEntity;
import com.bizunited.platform.titan.starter.repository.internal.ProcessTemplateNodePermissionRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-21 17:36
 * @Description: 流程模版节点权限配置持久化接口
 */
public interface ProcessTemplateNodePermissionRepository extends
    JpaRepository<ProcessTemplateNodePermissionEntity, String>,
    JpaSpecificationExecutor<ProcessTemplateNodePermissionEntity>,
    ProcessTemplateNodePermissionRepositoryCustom {

  /**
   * 根据操作编码统计
   * @param operateCode
   * @return
   */
  @Query("select count(*) from ProcessTemplateNodePermissionEntity ptnp where ptnp.operateCode = :operateCode")
  Long countByOperateCode(@Param("operateCode") String operateCode);

  /**
   * 根据操作编码统计,排除指定ID
   * @param operateCode
   * @return
   */
  @Query("select count(*) from ProcessTemplateNodePermissionEntity ptnp where ptnp.operateCode = :operateCode and ptnp.id <> :id")
  Long countByOperateCodeWithoutId(@Param("operateCode") String operateCode, @Param("id") String id);

  /**
   * 根据操作名称统计
   * @param operateName
   * @return
   */
  @Query("select count(*) from ProcessTemplateNodePermissionEntity ptnp where ptnp.operateCode = :operateName")
  Long countByOperateName(@Param("operateName") String operateName);

  /**
   * 根据操作名称统计,排除指定ID
   * @param operateName
   * @return
   */
  @Query("select count(*) from ProcessTemplateNodePermissionEntity ptnp where ptnp.operateName = :operateName and ptnp.id <> :id")
  Long countByOperateNameWithoutId(@Param("operateName") String operateName, @Param("id") String id);

  /**
   * 根据ID查明细
   * @param id
   * @return
   */
  @Query("select ptnp from ProcessTemplateNodePermissionEntity ptnp" +
      " inner join fetch ptnp.createUser cu" +
      " inner join fetch ptnp.modifyUser mu" +
      " where ptnp.id = :id")
  ProcessTemplateNodePermissionEntity findDetailById(@Param("id") String id);
}
