package com.bizunited.platform.titan.starter.repository;

import com.bizunited.platform.titan.entity.ProcessTemplateNodeEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Set;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-13 17:57
 * @Description: 流程节点的持久化接口
 */
@Repository("ProcessTemplateNodeRepository")
public interface ProcessTemplateNodeRepository extends
    JpaRepository<ProcessTemplateNodeEntity, String>,
    JpaSpecificationExecutor<ProcessTemplateNodeEntity> {

  /**
   * 根据流程模版ID获取节点列表
   * @param processTemplateId
   * @return
   */
  @Query("select ptn from ProcessTemplateNodeEntity ptn inner join ptn.processTemplate pt where pt.id = :processTemplateId")
  List<ProcessTemplateNodeEntity> findByProcessTemplateId(@Param("processTemplateId") String processTemplateId);

  /**
   * 根据表单ID和流程节点ID查询流程节点
   * @param templateId
   * @param processNodeId
   * @return
   */
  @Query("select ptn from ProcessTemplateNodeEntity ptn inner join ptn.processTemplate pt where pt.id = :templateId and ptn.processNodeId = :processNodeId")
  ProcessTemplateNodeEntity findByProcessTemplateIdAndProcessNodeId(@Param("templateId") String templateId, @Param("processNodeId") String processNodeId);

  /**
   * 根据表单ID和流程节点ID查询流程节点详情
   * @param templateId
   * @param processNodeId
   * @return
   */
  @Query("select ptn from ProcessTemplateNodeEntity ptn inner join ptn.processTemplate pt " +
      " left join fetch ptn.processTemplateNodePermission ptnptnp" +
      " left join fetch ptn.assignment ptna" +
      " left join fetch ptn.processTemplateNodeMulti ptnptnm" +
      " left join fetch ptna.processListener ptnapl" +
      " left join fetch ptna.script ptnas" +
      " where pt.id = :templateId and ptn.processNodeId = :processNodeId")
  ProcessTemplateNodeEntity findDetailsByProcessTemplateIdAndProcessNodeId(@Param("templateId") String templateId, @Param("processNodeId") String processNodeId);


  /**
   * 根据模版ID查询节点详情列表
   * @param processTemplateId
   * @return
   */
  @Query("select ptn from ProcessTemplateNodeEntity ptn inner join ptn.processTemplate pt" +
      " left join fetch ptn.processTemplateNodePermission ptnptnp" +
      " left join fetch ptnptnp.createUser ptnptnpcu" +
      " left join fetch ptnptnp.modifyUser ptnptnpmu" +
      " left join fetch ptn.processTemplateNodeMulti ptnptnm" +
      " left join fetch ptn.assignment ptna" +
      " left join fetch ptna.processListener ptnapl" +
      " left join fetch ptna.script ptnas" +
      " left join fetch ptnas.createUser ptnascu" +
      " left join fetch ptnas.modifyUser ptnasmu" +
      " where pt.id = :processTemplateId")
  Set<ProcessTemplateNodeEntity> findDetailsByProcessTemplateId(@Param("processTemplateId") String processTemplateId);

  /**
   * 根据模版ID查询节点详情列表
   * @param processTemplateId
   * @return
   */
  @Query("select ptn from ProcessTemplateNodeEntity ptn inner join ptn.processTemplate pt" +
      " left join fetch ptn.assignment ptna" +
      " left join fetch ptna.processListener ptnapl" +
      " left join fetch ptna.script ptnas" +
      " left join fetch ptnas.createUser ptnascu" +
      " left join fetch ptnas.modifyUser ptnasmu" +
      " where pt.id = :processTemplateId")
  Set<ProcessTemplateNodeEntity> findDetailsByProcessTemplateIdForAssignment(@Param("processTemplateId") String processTemplateId);

  /**
   * 查询有撤销标识的节点
   * @param templateId
   * @param cancelFlag
   * @return
   */
  @Query("select ptn from ProcessTemplateNodeEntity ptn inner join ptn.processTemplate pt where pt.id = :templateId and ptn.cancelFlag = :cancelFlag")
  List<ProcessTemplateNodeEntity> findByProcessTemplateIdAndCancelFlag(@Param("templateId") String templateId, @Param("cancelFlag") boolean cancelFlag);
}
