package com.bizunited.platform.titan.starter.repository;

import com.bizunited.platform.titan.entity.ProcessTemplatePermissionEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Set;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-13 16:56
 * @Description: 流程模版权限配置的持久化
 */
@Repository("ProcessTemplatePermissionRepository")
public interface ProcessTemplatePermissionRepository extends
    JpaRepository<ProcessTemplatePermissionEntity, String>,
    JpaSpecificationExecutor<ProcessTemplatePermissionEntity> {

  /**
   * 根据流程模版ID查询模版权限
   * @param processTemplateId
   * @return
   */
  @Query("select ptp from ProcessTemplatePermissionEntity ptp inner join ptp.processTemplate pt where pt.id = :processTemplateId")
  Set<ProcessTemplatePermissionEntity> findByProcessTemplateId(@Param("processTemplateId") String processTemplateId);

}
