package com.bizunited.platform.titan.starter.repository;

import com.bizunited.platform.titan.entity.ProcessTemplateEntity;
import com.bizunited.platform.titan.starter.repository.internal.ProcessTemplateRepositoryCustom;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-13 10:51
 * @Description: 流程模版的持久化服务
 */
@Repository("ProcessTemplateRepository")
public interface ProcessTemplateRepository extends
    JpaRepository<ProcessTemplateEntity, String>
    , JpaSpecificationExecutor<ProcessTemplateEntity>,
    ProcessTemplateRepositoryCustom {


  /**
   * 统计processKey的数量
   * @param processKey
   * @return
   */
  @Query("select count(*) from ProcessTemplateEntity pt where pt.processKey = :processKey")
  Long countByProcessKey(@Param("processKey") String processKey);

  /**
   * 统计processKey的数量,并排除ID
   * @param processKey
   * @param id
   * @return
   */
  @Query("select count(*) from ProcessTemplateEntity pt where pt.processKey = :processKey and pt.id <> :id")
  Long countByProcessKeyWithoutId(@Param("processKey") String processKey, @Param("id") String id);

  /**
   * 根据流程ID查询流程模版明细
   * @param id
   * @return
   */
  @Query("select distinct pt from ProcessTemplateEntity pt " +
      "left join fetch pt.createUser cu " +
      "left join fetch pt.modifyUser mu " +
      "left join fetch pt.onSubmitScript ss " +
      "left join fetch ss.createUser sscu " +
      "left join fetch ss.modifyUser ssmu " +
      "where pt.id = :id")
  ProcessTemplateEntity findDetailsById(@Param("id") String id);

  /**
   * 根据流程实例ID查询模版详情信息
   * @param processInstanceId
   * @return
   */
  @Query("select distinct pt from ProcessInstanceEntity pi " +
      "inner join pi.processTemplate pt " +
      "left join fetch pt.createUser cu " +
      "left join fetch pt.modifyUser mu " +
      "left join fetch pt.onSubmitScript ss " +
      "left join fetch ss.createUser sscu " +
      "left join fetch ss.modifyUser ssmu " +
      "where pi.processInstanceId = :processInstanceId")
  ProcessTemplateEntity findDetailsByProcessInstanceId(@Param("processInstanceId") String processInstanceId);

  /**
   * 获取最新已发布版本的模版
   * @param processKey
   * @return
   */
  @Query("from ProcessTemplateEntity pt where pt.isLastDeployedVersion = 1 and pt.processKey = :processKey")
  ProcessTemplateEntity findLastDeployVersionByProcessKey(@Param("processKey") String processKey);

  /**
   * 获取最新版本流程版本
   * @param processKey
   * @return
   */
  @Query("from ProcessTemplateEntity pt where pt.isLastVersion = 1 and pt.processKey = :processKey")
  ProcessTemplateEntity findLastVersionByProcessKey(@Param("processKey") String processKey);

  /**
   * 根据流程key查询排序列表
   * @param processKey
   * @param sort
   * @return
   */
  List<ProcessTemplateEntity> findByProcessKey(String processKey, Sort sort);

}
