package com.bizunited.platform.titan.starter.repository;

import com.bizunited.platform.titan.entity.ProcessVariableEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Set;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-21 10:08
 * @Description: 流程变量持久化接口
 */
@Repository("ProcessVariableRepository")
public interface ProcessVariableRepository extends
    JpaRepository<ProcessVariableEntity, String>,
    JpaSpecificationExecutor<ProcessVariableEntity> {

  /**
   * 根据数据源ID查询变量
   * @param sourceId
   * @return
   */
  Set<ProcessVariableEntity> findBySourceId(String sourceId);

  @Modifying
  @Query("delete from ProcessVariableEntity pv where pv.sourceId = :sourceId")
  void deleteBySourceId(@Param("sourceId") String sourceId);
}
