package com.bizunited.platform.titan.starter.repository.internal;

import org.flowable.engine.impl.persistence.entity.ExecutionEntityImpl;
import org.springframework.stereotype.Repository;

/**
 * 流程引擎Execution持久化接口定义
 * @Author: Paul Chan
 * @Date: 2019-06-03 21:41
 */
@Repository("ExecutionRepositoryCustom")
public interface ExecutionRepositoryCustom {


  /**
   * 删除运行是执行实例
   * @param executionId
   * @return
   */
  int deleteRuExecutionById(String executionId);

  /**
   * 更新执行实例的活动状态
   * @param executionId
   * @param active
   */
  int updateIsActiveById(String executionId, int active);

  int insert(ExecutionEntityImpl execution);
}
