package com.bizunited.platform.titan.starter.repository.internal;

import org.flowable.common.engine.impl.cfg.IdGenerator;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import java.util.Date;

/**
 * @Author: Paul Chan
 * @Date: 2019-06-03 21:42
 */
@Repository("ExecutionRepositoryImpl")
public class ExecutionRepositoryImpl implements ExecutionRepositoryCustom {

  @Autowired
  private IdGenerator idGenerator;
  @Autowired
  private EntityManager entityManager;

  @Override
  public int deleteRuExecutionById(String executionId) {
    String sql = "delete from ACT_RU_EXECUTION where ID_ = :executionId";
    Query query = entityManager.createNativeQuery(sql);
    query.setParameter("executionId", executionId);
    return query.executeUpdate();
  }

  @Override
  public int updateIsActiveById(String executionId, int active) {
    String sql = "update ACT_RU_EXECUTION set IS_ACTIVE_ = :active where ID_ = :executionId";
    Query query = entityManager.createNativeQuery(sql);
    query.setParameter("executionId", executionId);
    query.setParameter("active", active);
    return query.executeUpdate();
  }

  @Override
  public int insert(ExecutionEntityImpl execution){
    StringBuilder sql = new StringBuilder("INSERT INTO `formengine_starter_12`.`ACT_RU_EXECUTION`(`ID_`, `REV_`, `PROC_INST_ID_`, `BUSINESS_KEY_`, ");
    sql.append("`PARENT_ID_`, `PROC_DEF_ID_`, `SUPER_EXEC_`, `ROOT_PROC_INST_ID_`, `ACT_ID_`, `IS_ACTIVE_`, `IS_CONCURRENT_`, ");
    sql.append("`IS_SCOPE_`, `IS_EVENT_SCOPE_`, `IS_MI_ROOT_`, `SUSPENSION_STATE_`, `CACHED_ENT_STATE_`, `TENANT_ID_`, `NAME_`, ");
    sql.append("`START_ACT_ID_`, `START_TIME_`, `START_USER_ID_`, `LOCK_TIME_`, `IS_COUNT_ENABLED_`, `EVT_SUBSCR_COUNT_`, ");
    sql.append("`TASK_COUNT_`, `JOB_COUNT_`, `TIMER_JOB_COUNT_`, `SUSP_JOB_COUNT_`, `DEADLETTER_JOB_COUNT_`, `VAR_COUNT_`, ");
    sql.append("`ID_LINK_COUNT_`, `CALLBACK_ID_`, `CALLBACK_TYPE_`) VALUES (:id, :rev, :procInstId, NULL, ");
    sql.append(":parentId, :procDefId, NULL, :rootProcInstId, :actId, :isActive, 0, 0, 0, 0, 1, NULL, NULL, NULL, NULL, ");
    sql.append(" :startTime, NULL, NULL, 1, 0, 1, 0, 0, 0, 0, 0, 0, NULL, NULL)");
    Query query = entityManager.createNativeQuery(sql.toString());
    query.setParameter("id", idGenerator.getNextId());
    query.setParameter("rev", execution.getRevision());
    query.setParameter("procInstId", execution.getProcessInstanceId());
    query.setParameter("parentId", execution.getParentId());
    query.setParameter("procDefId", execution.getProcessDefinitionId());
    query.setParameter("rootProcInstId", execution.getRootProcessInstanceId());
    query.setParameter("actId", execution.getActivityId());
    query.setParameter("isActive", execution.isActive());
    query.setParameter("startTime", new Date());
    return query.executeUpdate();
  }

}
