package com.bizunited.platform.titan.starter.repository.internal;

import org.flowable.engine.history.HistoricActivityInstance;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 历史活动节点持久化自定义实现接口
 * @Author: Paul Chan
 * @Date: 2019-05-28 13:02
 */
@Repository("HistoricActivityInstanceRepositoryCustom")
public interface HistoricActivityInstanceRepositoryCustom {

  /**
   * 删除历史活动信息
   * @param historicActivityInstances
   */
  void delete(List<HistoricActivityInstance> historicActivityInstances);

  /**
   * 删除历史活动信息
   * @param historicActivityInstance
   * @return
   */
  int delete(HistoricActivityInstance historicActivityInstance);

  /**
   * 根据任务ID删除活动实例
   * @param taskId
   * @return
   */
  int deleteByTaskId(String taskId);
}
