package com.bizunited.platform.titan.starter.repository.internal;

import org.apache.commons.lang3.Validate;
import org.flowable.engine.history.HistoricActivityInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import java.util.List;

/**
 * 历史活动节点持久化自定义实现
 * @Author: Paul Chan
 * @Date: 2019-05-28 13:03
 */
@Repository("HistoricActivityInstanceRepositoryImpl")
public class HistoricActivityInstanceRepositoryImpl implements HistoricActivityInstanceRepositoryCustom {

  @Autowired
  private EntityManager entityManager;

  @Override
  public void delete(List<HistoricActivityInstance> historicActivityInstances){
    Validate.notNull(historicActivityInstances, "删除对象不能为空");
    historicActivityInstances.forEach(h -> delete(h));
  }

  @Override
  public int delete(HistoricActivityInstance historicActivityInstance){
    Validate.notNull(historicActivityInstance, "删除对象不能为空");
    String sql  = "delete from ACT_HI_ACTINST where ID_ = :id";
    Query query = entityManager.createNativeQuery(sql);
    query.setParameter("id", historicActivityInstance.getId());
    return query.executeUpdate();
  }

  @Override
  public int deleteByTaskId(String taskId) {
    Validate.notNull(taskId, "删除对象不能为空");
    String sql  = "delete from ACT_HI_ACTINST where TASK_ID_ = :taskId";
    Query query = entityManager.createNativeQuery(sql);
    query.setParameter("taskId", taskId);
    return query.executeUpdate();
  }

}
