package com.bizunited.platform.titan.starter.repository.internal;

import com.bizunited.platform.rbac.server.vo.UserVo;
import com.bizunited.platform.titan.entity.ProcessCarbonCopyEntity;
import com.bizunited.platform.titan.entity.ProcessInstanceEntity;
import com.bizunited.platform.titan.entity.ProcessTemplateEntity;
import com.bizunited.platform.titan.starter.service.TitanToolkitService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.bizunited.platform.titan.starter.common.Constants.DEFAULT_QUERY_COVER_CODE;
import static com.bizunited.platform.titan.starter.common.Constants.USERNAME_PREFIX;

/**
 * 流程抄送记录的持久化自定义实现
 * @Author: Paul Chan
 * @Date: 2019-05-27 09:59
 */
@Repository("ProcessCarbonCopyRepositoryImpl")
public class ProcessCarbonCopyRepositoryImpl implements ProcessCarbonCopyRepositoryCustom {

  @Autowired
  private EntityManager entityManager;
  @Autowired
  @Qualifier("TitanToolkitService")
  private TitanToolkitService titanToolkitService;

  @SuppressWarnings("unchecked")
  @Override
  public Page<ProcessCarbonCopyEntity> findMyByConditions(Pageable pageable, ProcessCarbonCopyEntity carbonCopy, UserVo user) {
    StringBuilder hql = new StringBuilder("select pcc from ProcessCarbonCopyEntity pcc ");
    hql.append(" inner join fetch pcc.processInstance pi ");
    hql.append(" inner join fetch pi.processTemplate pt");
    hql.append(" inner join fetch pi.applicantUser piau ");
    hql.append(" inner join fetch pcc.ccUser pccccu");
    hql.append(" inner join fetch pcc.receiveAssignment pcca");
    hql.append(" where (pcca.assignment = :account or pcca.assignment in :positionCodes) ");
    StringBuilder countHql = new StringBuilder("select count(*) from ProcessCarbonCopyEntity pcc ");
    countHql.append(" inner join pcc.processInstance pi ");
    countHql.append(" inner join pi.processTemplate pt");
    countHql.append(" inner join pi.applicantUser piau ");
    countHql.append(" inner join pcc.ccUser pccccu");
    countHql.append(" inner join pcc.receiveAssignment pcca");
    countHql.append(" where (pcca.assignment = :account or pcca.assignment in :positionCodes) ");
    StringBuilder conditions = new StringBuilder();
    Map<String, Object> parameter = new HashMap<>(16);
    parameter.put("account", StringUtils.join(USERNAME_PREFIX, user.getAccount()));
    List<String> positionCodes = titanToolkitService.getAssignmentPositionCodes(user.getPositions());
    if(CollectionUtils.isEmpty(positionCodes)) positionCodes.add(DEFAULT_QUERY_COVER_CODE);
    parameter.put("positionCodes", positionCodes);
    if(carbonCopy != null){
      ProcessInstanceEntity processInstance = carbonCopy.getProcessInstance();
      if(processInstance != null){
        ProcessTemplateEntity processTemplate = processInstance.getProcessTemplate();
        if(StringUtils.isNotBlank(processInstance.getFormNo())){
          conditions.append(" and pi.formNo = :formNo ");
          parameter.put("formNo", processInstance.getFormNo());
        }
        if(processInstance.getLatestSubmitTime() != null){
          conditions.append(" and pi.latestSubmitTime >= :latestSubmitTime ");
          parameter.put("latestSubmitTime", processInstance.getLatestSubmitTime());
        }
        if(processTemplate != null){
          if(StringUtils.isNotBlank(processTemplate.getProcessKey())){
            conditions.append(" and pt.processKey = :processKey ");
            parameter.put("processKey", processTemplate.getProcessKey());
          }
          if(StringUtils.isNotBlank(processTemplate.getProcessName())){
            conditions.append(" and pt.processName = :processName ");
            parameter.put("processName", processTemplate.getProcessName());
          }
        }
      }
    }
    hql.append(conditions.toString())
        .append(" order by pcc.state asc, pcc.createTime desc ");
    countHql.append(conditions.toString());
    Query query = entityManager.createQuery(hql.toString());
    Query countQuery = entityManager.createQuery(countHql.toString());
    parameter.forEach((k, v) -> {
      query.setParameter(k, v);
      countQuery.setParameter(k, v);
    });
    query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
    query.setMaxResults(pageable.getPageSize());
    List<ProcessCarbonCopyEntity> result = query.getResultList();
    long count = (long)countQuery.getResultList().get(0);
    PageImpl<ProcessCarbonCopyEntity> currentPage = new PageImpl<>(result ,pageable, count);
    return currentPage;
  }

}
