package com.bizunited.platform.titan.starter.repository.internal;

import com.bizunited.platform.titan.entity.ProcessInstanceEntity;
import com.bizunited.platform.titan.entity.ProcessTemplateEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 流程实例持久化自定义实现
 * @Author: Paul Chan
 * @Date: 2019-05-25 14:23
 */
@Repository("ProcessInstanceRepositoryImpl")
public class ProcessInstanceRepositoryImpl implements ProcessInstanceRepositoryCustom {

  @Autowired
  private EntityManager entityManager;

  @SuppressWarnings("unchecked")
  @Override
  public Page<ProcessInstanceEntity> findByConditions(Pageable pageable, ProcessInstanceEntity processInstance) {
    StringBuilder hql = new StringBuilder("select distinct pi from ProcessInstanceEntity pi ");
    hql.append(" inner join fetch pi.processTemplate pipt ");
    hql.append(" inner join fetch pi.applicantUser piu ");
    hql.append(" left join fetch pi.latestAssignment pila ");
    hql.append(" left join fetch pi.latestNode piln ");
    hql.append(" where 1=1 ");
    StringBuilder countHql = new StringBuilder("select count(distinct pi) from ProcessInstanceEntity pi ");
    countHql.append(" inner join pi.processTemplate pipt ");
    countHql.append(" inner join pi.applicantUser piu ");
    countHql.append(" left join pi.latestAssignment pila ");
    countHql.append(" left join pi.latestNode piln ");
    countHql.append(" where 1=1 ");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameter = new HashMap<>(16);
    if(processInstance != null){
      if(processInstance.getProcessState() != null){
        condition.append(" and pi.processState = :processState ");
        parameter.put("processState", processInstance.getProcessState());
      }
      if(StringUtils.isNotBlank(processInstance.getFormNo())){
        condition.append(" and pi.formNo = :formNo ");
        parameter.put("formNo", processInstance.getFormNo());
      }
      if(processInstance.getLatestSubmitTime() != null){
        condition.append(" and pi.latestSubmitTime >= :latestSubmitTime ");
        parameter.put("latestSubmitTime", processInstance.getLatestSubmitTime());
      }
      if(processInstance.getApplicantUser() != null){
        condition.append(" and piu.id = :applicantUser ");
        parameter.put("applicantUser", processInstance.getApplicantUser().getId());
      }
      ProcessTemplateEntity processTemplate = processInstance.getProcessTemplate();
      if(processTemplate != null){
        if(StringUtils.isNotBlank(processTemplate.getProcessKey())){
          condition.append(" and pipt.processKey = :processKey ");
          parameter.put("processKey", processTemplate.getProcessKey());
        }
        if(StringUtils.isNotBlank(processTemplate.getProcessName())){
          condition.append(" and pipt.processName = :processName ");
          parameter.put("processName", processTemplate.getProcessName());
        }
      }
    }
    hql.append(condition.toString()).append(" order by pi.latestSubmitTime desc");
    countHql.append(condition.toString());
    Query query = entityManager.createQuery(hql.toString());
    Query countQuery = entityManager.createQuery(countHql.toString());
    parameter.forEach((k, v) -> {
      query.setParameter(k, v);
      countQuery.setParameter(k, v);
    });
    query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
    query.setMaxResults(pageable.getPageSize());
    List<ProcessInstanceEntity> result = query.getResultList();
    long count = (long)countQuery.getResultList().get(0);
    PageImpl<ProcessInstanceEntity> currentPage = new PageImpl<>(result ,pageable, count);
    return currentPage;
  }

}
