package com.bizunited.platform.titan.starter.repository.internal;

import com.bizunited.platform.titan.entity.ProcessListenerEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-15 20:22
 * @Description: 流程监听器自定义持久化实现
 */
public class ProcessListenerRepositoryImpl implements ProcessListenerRepositoryCustom {

  @Autowired
  private EntityManager entityManager;

  @SuppressWarnings("unchecked")
  @Override
  public Page<ProcessListenerEntity> findByConditions(ProcessListenerEntity processListener, Pageable pageable) {
    StringBuilder hql = new StringBuilder("select pl from ProcessListenerEntity pl where 1=1 ");
    StringBuilder countHql = new StringBuilder("select count(*) from ProcessListenerEntity pl where 1=1 ");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameter = new HashMap<>(16);
    if(StringUtils.isNotBlank(processListener.getListenerEvent())){
      condition.append(" and pl.listenerEvent = :listenerEvent");
      parameter.put("listenerEvent", processListener.getListenerEvent());
    }
    if(StringUtils.isNotBlank(processListener.getName())){
      condition.append(" and pl.name = :name");
      parameter.put("name", processListener.getName());
    }
    if(StringUtils.isNotBlank(processListener.getListenerClass())){
      condition.append(" and pl.listenerClass = :listenerClass");
      parameter.put("listenerClass", processListener.getListenerClass());
    }
    if(processListener.getState() != null){
      condition.append(" and pl.state = :state");
      parameter.put("state", processListener.getState());
    }
    if(processListener.getType() != null){
      condition.append(" and pl.type = :type");
      parameter.put("type", processListener.getType());
    }
    if(processListener.getExecuteMode() != null){
      condition.append(" and pl.executeMode = :executeMode");
      parameter.put("executeMode", processListener.getExecuteMode());
    }
    hql.append(condition);
    countHql.append(condition);
    Query query = entityManager.createQuery(hql.toString());
    Query countQuery = entityManager.createQuery(countHql.toString());
    parameter.forEach((k, v) -> {
      query.setParameter(k, v);
      countQuery.setParameter(k, v);
    });
    query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
    query.setMaxResults(pageable.getPageSize());
    List<ProcessListenerEntity> result = query.getResultList();
    long count = (long)countQuery.getResultList().get(0);
    PageImpl<ProcessListenerEntity> currentPage = new PageImpl<>(result ,pageable, count);
    return currentPage;
  }
}
