package com.bizunited.platform.titan.starter.repository.internal;

import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.rbac.server.vo.UserVo;
import com.bizunited.platform.titan.entity.ProcessInstanceOperateRecordEntity;
import com.bizunited.platform.titan.vo.TaskVo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

/**
 * 流程任务的自定义持久化
 * @Author: Paul Chan
 * @Date: 2019-05-25 20:17
 */
@Repository("ProcessTaskRepositoryCustom")
public interface ProcessTaskRepositoryCustom {

  /**
   * 查询我的待办任务
   * @param user
   * @param taskVo
   * @param pageable
   * @return
   */
  Page<TaskVo> findMyTasksByConditions(UserVo user, TaskVo taskVo, Pageable pageable);

  /**
   * 查询我已办的任务,只查询操作为'BTN_001','BTN_002','BTN_003','BTN_012','BTN_013'的记录
   * @param pageable
   * @param record
   * @param user
   * @return
   */
  Page<ProcessInstanceOperateRecordEntity> findDoneByConditions(Pageable pageable, ProcessInstanceOperateRecordEntity record, UserEntity user);


}
