package com.bizunited.platform.titan.starter.repository.internal;

import com.bizunited.platform.titan.entity.ProcessTemplateNodePermissionEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import java.util.List;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-21 19:23
 * @Description: 流程节点权限持久化自定义实现
 */
public class ProcessTemplateNodePermissionRepositoryImpl implements ProcessTemplateNodePermissionRepositoryCustom {

  @Autowired
  private EntityManager entityManager;

  @SuppressWarnings("unchecked")
  @Override
  public Page<ProcessTemplateNodePermissionEntity> findByConditions(ProcessTemplateNodePermissionEntity nodePermission, Pageable pageable) {
    StringBuilder hql = new StringBuilder("select ptnp from ProcessTemplateNodePermissionEntity ptnp where 1=1 ");
    StringBuilder countHql = new StringBuilder("select count(*) from ProcessTemplateNodePermissionEntity ptnp where 1=1 ");
    StringBuilder conditions = new StringBuilder();
    if(StringUtils.isNotBlank(nodePermission.getOperateCode())){
      conditions.append(" and ptnp.operateCode = :operateCode");
    }
    if(StringUtils.isNotBlank(nodePermission.getOperateName())){
      conditions.append(" and ptnp.operateName = :operateName");
    }
    hql.append(conditions);
    countHql.append(conditions);
    Query query = entityManager.createQuery(hql.toString());
    Query countQuery = entityManager.createQuery(countHql.toString());
    if(StringUtils.isNotBlank(nodePermission.getOperateCode())){
      query.setParameter("operateCode", nodePermission.getOperateCode());
      countQuery.setParameter("operateCode", nodePermission.getOperateCode());
    }
    if(StringUtils.isNotBlank(nodePermission.getOperateName())){
      query.setParameter("operateName", nodePermission.getOperateName());
      countQuery.setParameter("operateName", nodePermission.getOperateName());
    }
    query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
    query.setMaxResults(pageable.getPageSize());
    List<ProcessTemplateNodePermissionEntity> result = query.getResultList();
    long count = (long)countQuery.getResultList().get(0);
    PageImpl<ProcessTemplateNodePermissionEntity> currentPage = new PageImpl<>(result ,pageable, count);
    return currentPage;
  }
}
