package com.bizunited.platform.titan.starter.repository.internal;

import com.bizunited.platform.rbac.server.vo.UserVo;
import com.bizunited.platform.titan.entity.ProcessTemplateEntity;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-13 11:13
 * @Description: 流程模版持久化自定义实现接口
 */
@Repository("ProcessTemplateRepositoryCustom")
public interface ProcessTemplateRepositoryCustom {

  /**
   * 分页条件查询流程模版数据
   * @param pageable
   * @param processTemplate
   * @return
   */
  Page<ProcessTemplateEntity> findByConditions(Pageable pageable, ProcessTemplateEntity processTemplate);

  /**
   * 分页查询可发起的流程模版
   * @param pageable
   * @param processTemplate
   * @param user
   * @return
   */
  Page<ProcessTemplateEntity> findStartableByConditions(Pageable pageable, ProcessTemplateEntity processTemplate, UserVo user);
}
