package com.bizunited.platform.titan.starter.repository.internal;

import com.bizunited.platform.rbac.server.vo.*;
import com.bizunited.platform.titan.entity.ProcessTemplateEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.bizunited.platform.titan.starter.common.Constants.DEFAULT_QUERY_COVER_CODE;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-13 11:14
 * @Description: 流程模版持久化定制方法
 */
@Repository("ProcessTemplateRepositoryCustomImpl")
public class ProcessTemplateRepositoryImpl implements ProcessTemplateRepositoryCustom {

  @Autowired
  private EntityManager entityManager;

  @SuppressWarnings("unchecked")
  @Override
  public Page<ProcessTemplateEntity> findByConditions(Pageable pageable, ProcessTemplateEntity processTemplate) {
    StringBuilder hql = new StringBuilder("select pt from ProcessTemplateEntity pt where 1=1 ");
    StringBuilder countHql = new StringBuilder("select count(*) from ProcessTemplateEntity pt where 1=1 ");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameter = new HashMap<>(4);
    if(processTemplate != null){
      if(StringUtils.isNotBlank(processTemplate.getProcessKey())){
        condition.append(" AND pt.processKey = :processKey");
        parameter.put("processKey", processTemplate.getProcessKey());
      }
      if(StringUtils.isNotBlank(processTemplate.getProcessName())){
        condition.append(" AND pt.processName = :processName");
        parameter.put("processName", processTemplate.getProcessName());
      }
      if(StringUtils.isNotBlank(processTemplate.getFormName())){
        condition.append(" AND pt.formName = :getFormName");
        parameter.put("formName", processTemplate.getProcessName());
      }
      if(processTemplate.getLastVersion() != null){
        condition.append(" AND pt.isLastVersion = :isLastVersion");
        parameter.put("isLastVersion", processTemplate.getLastVersion());
      }
    }
    hql.append(condition.toString()).append(" order by pt.modifyTime desc");
    countHql.append(condition.toString());
    Query query = entityManager.createQuery(hql.toString());
    Query countQuery = entityManager.createQuery(countHql.toString());
    parameter.forEach((k, v) -> {
      query.setParameter(k, v);
      countQuery.setParameter(k, v);
    });
    query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
    query.setMaxResults(pageable.getPageSize());
    List<ProcessTemplateEntity> result = query.getResultList();
    long count = (long)countQuery.getResultList().get(0);
    PageImpl<ProcessTemplateEntity> currentPage = new PageImpl<>(result ,pageable, count);
    return currentPage;
  }

  @SuppressWarnings("unchecked")
  @Override
  public Page<ProcessTemplateEntity> findStartableByConditions(Pageable pageable, ProcessTemplateEntity processTemplate, UserVo user) {
    StringBuilder hql = new StringBuilder("select distinct pt from ProcessTemplateEntity pt left join pt.permissions ptp where pt.isLastDeployedVersion = 1 and pt.processState = 1 ");
    StringBuilder countHql = new StringBuilder("select count(distinct pt) from ProcessTemplateEntity pt left join pt.permissions ptp where pt.isLastDeployedVersion = 1 and pt.processState = 1 ");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameter = new HashMap<>(16);
    if(processTemplate != null){
      if(StringUtils.isNotBlank(processTemplate.getProcessKey())){
        condition.append(" AND pt.processKey = :processKey");
        parameter.put("processKey", processTemplate.getProcessKey());
      }
      if(StringUtils.isNotBlank(processTemplate.getProcessName())){
        condition.append(" AND pt.processName = :processName");
        parameter.put("processName", processTemplate.getProcessName());
      }
      if(StringUtils.isNotBlank(processTemplate.getFormName())){
        condition.append(" AND pt.formName = :formName");
        parameter.put("formName", processTemplate.getFormName());
      }
    }
    condition.append(this.getPermissionCondition(user, parameter));
    hql.append(condition.toString()).append(" order by pt.deployTime desc");
    countHql.append(condition.toString());
    Query query = entityManager.createQuery(hql.toString());
    Query countQuery = entityManager.createQuery(countHql.toString());
    parameter.forEach((k, v) -> {
      query.setParameter(k, v);
      countQuery.setParameter(k, v);
    });
    query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
    query.setMaxResults(pageable.getPageSize());
    List<ProcessTemplateEntity> result = query.getResultList();
    long count = (long)countQuery.getResultList().get(0);
    PageImpl<ProcessTemplateEntity> currentPage = new PageImpl<>(result ,pageable, count);
    return currentPage;
  }

  /**
   * 生成权限的条件
   * @param user
   * @param parameter
   * @return
   */
  private StringBuilder getPermissionCondition(UserVo user, Map<String, Object> parameter){
    List<String> roles = new ArrayList<>();
    if(!CollectionUtils.isEmpty(user.getRoles())){
      roles = user.getRoles().stream().map(RoleVo::getRoleCode).collect(Collectors.toList());
    } else {
      roles.add(DEFAULT_QUERY_COVER_CODE);
    }
    List<String> positions = new ArrayList<>();
    if(!CollectionUtils.isEmpty(user.getPositions())){
      positions = user.getPositions().stream().map(PositionVo::getCode).collect(Collectors.toList());
    } else {
      positions.add(DEFAULT_QUERY_COVER_CODE);
    }
    List<String> orgs = new ArrayList<>();
    if(!CollectionUtils.isEmpty(user.getOrgs())){
      orgs = user.getOrgs().stream().map(OrganizationVo::getCode).collect(Collectors.toList());
    } else {
      orgs.add(DEFAULT_QUERY_COVER_CODE);
    }
    List<String> groups = new ArrayList<>();
    if(!CollectionUtils.isEmpty(user.getGroups())){
      groups = user.getGroups().stream().map(UserGroupVo::getId).collect(Collectors.toList());
    } else {
      groups.add(DEFAULT_QUERY_COVER_CODE);
    }
    parameter.put("account", user.getAccount());
    parameter.put("roles", roles);
    parameter.put("positions", positions);
    parameter.put("orgs", orgs);
    parameter.put("groups", groups);
    StringBuilder condition = new StringBuilder(" and (ptp.id is null ");
    condition.append(" or ptp.type = 0 ");
    condition.append(" or (ptp.type = 1 and ptp.permissionValue = :account) ");
    condition.append(" or (ptp.type = 2 and ptp.permissionValue in :roles)");
    condition.append(" or (ptp.type = 3 and ptp.permissionValue in :groups) ");
    condition.append(" or (ptp.type = 4 and ptp.permissionValue in :positions) ");
    condition.append(" or (ptp.type = 5 and ptp.permissionValue in :orgs) ");
    condition.append(")");
    return condition;
  }


}
