package com.bizunited.platform.titan.starter.service;

import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.titan.entity.ProcessAssignmentEntity;

import java.util.List;
import java.util.Set;

/**
 * 流程审批人服务接口定义
 * @Author: Paul Chan
 * @Date: 2019-05-31 10:44
 */
public interface ProcessAssignmentService {

  /**
   * 保存流程审批人,保存一个结合，根据ID去判断删除、更新和新增
   * @param resourceId
   * @param assignments
   * @return
   */
  Set<ProcessAssignmentEntity> save(String resourceId, Set<ProcessAssignmentEntity> assignments);

  /**
   * 保存单个流程审批人，在此情况下审批人与resourceId为一对一关系，存在则更新，不存在则新增
   * 一个资源下有多个代理人时，不要调用此方法，此方法会保证一个资源下只有一个代理人
   * 请调用批量保存方法：com.bizunited.platform.titan.starter.service.ProcessAssignmentService#save(java.lang.String, java.util.Set)
   * @param resourceId
   * @param assignment
   * @return
   */
  ProcessAssignmentEntity save(String resourceId, ProcessAssignmentEntity assignment);

  /**
   * 根据资源ID删除
   * @param resourceId
   */
  void deleteByResourceId(String resourceId);

  /**
   * 根据资源ID查询
   * @param resourceId
   * @return
   */
  Set<ProcessAssignmentEntity> findByResourceId(String resourceId);

  /**
   * 判断用户与代理人是否是同一个
   * @param user
   * @param assignment
   * @return
   */
  boolean equals(UserEntity user, String assignment);

  /**
   * 解析代理人信息, 获取的代理人只是一个初始化的对象，并未持久化
   * @param assignment
   * @return
   */
  ProcessAssignmentEntity findAssignment(String assignment);

  /**
   * 保存代理人信息,一个资源下有多个代理人时，不要调用此方法，此方法会保证一个资源下只有一个代理人
   * 请调用批量保存方法：com.bizunited.platform.titan.starter.service.ProcessAssignmentService#save(java.lang.String, java.util.Set)
   * @param resourceId
   * @param assignment
   * @return
   */
  ProcessAssignmentEntity save(String resourceId, String assignment);

  /**
   * 判断用户是否在代理人中
   * @param assignments
   * @param user
   * @return
   */
  boolean contains(List<String> assignments, UserEntity user);

  /**
   * 验证代理人格式是否正确，同时验证了代理人不能为空
   * @param assignments
   */
  void valid(List<String> assignments);

  /**
   * 验证代理人格式是否正确，同时验证了代理人不能为空
   * @param assignment
   */
  void valid(String assignment);

}
