package com.bizunited.platform.titan.starter.service;

import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.titan.entity.ProcessCarbonCopyEntity;
import com.bizunited.platform.titan.entity.ProcessInstanceEntity;
import org.flowable.task.api.Task;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.security.Principal;
import java.util.List;

/**
 * 流程任务抄送服务的接口定义
 * @Author: Paul Chan
 * @Date: 2019-05-24 15:58
 */
public interface ProcessCarbonCopyService {

  /**
   * 创建流程任务抄送记录
   * @param task
   * @param processInstance
   * @param ccUser
   * @param assignments
   * @return
   */
  List<ProcessCarbonCopyEntity> create(Task task, ProcessInstanceEntity processInstance, UserEntity ccUser, List<String> assignments);


  /**
   * 条件分页查询我的抄送列表
   * @param pageable
   * @param principal
   * @param carbonCopy
   * @return
   */
  Page<ProcessCarbonCopyEntity> findMyByConditions(Pageable pageable, Principal principal, ProcessCarbonCopyEntity carbonCopy);

  /**
   * 阅读抄送信息
   * @param id
   * @param principal
   */
  void read(String id, Principal principal);
}
