package com.bizunited.platform.titan.starter.service;

import com.bizunited.platform.titan.entity.ProcessCheckRecordEntity;
import com.bizunited.platform.titan.entity.ProcessTemplateEntity;

import java.security.Principal;
import java.util.List;
import java.util.Map;

/**
 * 流程检测服务接口定义
 * @Author: Paul Chan
 * @Date: 2019-06-17 15:05
 */
public interface ProcessCheckRecordService {
  /**
   * 检测流程
   * @param templateId
   * @param assignment
   * @param variables
   * @param principal
   * @return
   */
  ProcessCheckRecordEntity checkProcess(String templateId, String assignment, Map<String, Object> variables, Principal principal);
  /**
   * 检测流程,在新的事务中运行，并在运行完成后回滚事务
   * @param template
   * @param record
   * @param variables
   */
  void checkProcess(ProcessTemplateEntity template, ProcessCheckRecordEntity record, Map<String, Object> variables);
  /**
   * 根据模版ID查询流程检测记录
   * @param templateId
   * @return
   */
  List<ProcessCheckRecordEntity> findByTemplateId(String templateId);
  /**
   * 查询流程检测详情
   * @param id
   * @return
   */
  ProcessCheckRecordEntity findDetailById(String id);
}
