package com.bizunited.platform.titan.starter.service;

import com.bizunited.platform.titan.entity.ProcessInstanceAttachmentEntity;

import java.security.Principal;
import java.util.Set;

/**
 * 流程实例附件服务接口定义
 * @Author: Paul Chan
 * @Date: 2019-06-10 14:11
 */
public interface ProcessInstanceAttachmentService {

  /**
   * 保存附件信息
   * @param processInstanceId
   * @param attachments
   * @param principal
   * @return
   */
  Set<ProcessInstanceAttachmentEntity> create(String processInstanceId, Set<ProcessInstanceAttachmentEntity> attachments, Principal principal);

  /**
   * 根据ID删除附件信息
   * @param id
   */
  void deleteById(String id);

  /**
   * 根据流程实例查询附件信息
   * @param processInstanceId
   * @return
   */
  Set<ProcessInstanceAttachmentEntity> findDetailsByProcessInstanceId(String processInstanceId);
}
