package com.bizunited.platform.titan.starter.service;

import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.titan.entity.ProcessInstanceEntity;
import com.bizunited.platform.titan.entity.ProcessInstanceMsgEntity;
import com.bizunited.platform.titan.starter.common.enums.TaskOperateBtn;

import java.security.Principal;
import java.util.List;

/**
 * 流程实例消息的服务接口定义
 * @Author: Paul Chan
 * @Date: 2019-05-23 14:54
 */
public interface ProcessInstanceMsgService {

  /**
   * 创建流程实例消息
   * @param user
   * @param processInstance
   * @param content
   * @param operateBtn
   */
  ProcessInstanceMsgEntity create(UserEntity user, ProcessInstanceEntity processInstance, String content, TaskOperateBtn operateBtn);

  /**
   * 创建流程实例消息
   * @param msg
   * @param principal
   * @return
   */
  ProcessInstanceMsgEntity create(ProcessInstanceMsgEntity msg, Principal principal);

  /**
   * 根据流程实例ID查询留言记录，根据留言时间顺序排序，已树形结构返回
   * @param processInstanceId
   * @return
   */
  List<ProcessInstanceMsgEntity> findByProcessInstanceId(String processInstanceId);
}
