package com.bizunited.platform.titan.starter.service;

import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.titan.entity.ProcessInstanceEntity;
import com.bizunited.platform.titan.entity.ProcessInstanceOperateRecordEntity;
import com.bizunited.platform.titan.starter.common.enums.TaskOperateBtn;
import org.flowable.task.api.Task;

import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 流程操作记录服务的接口定义
 * @Author: Paul Chan
 * @Date: 2019-05-23 14:47
 */
public interface ProcessInstanceOperateRecordService {

  /**
   * 创建流程实例操作记录
   * @param task
   * @param processInstance
   * @param user
   * @param operateBtn
   * @param content
   * @return
   */
  ProcessInstanceOperateRecordEntity create(Task task, ProcessInstanceEntity processInstance, UserEntity user, TaskOperateBtn operateBtn, String content);

  /**
   * 根据流程实例、最后提交时间和按钮查询记录
   * @param processInstanceId
   * @param latestSubmitTime
   * @param btns
   */
  List<ProcessInstanceOperateRecordEntity> findByProcessInstanceIdAndLatestSubmitTimeAndBtns(String processInstanceId, Date latestSubmitTime, String... btns);

  /**
   * 根据流程实例ID查询
   * @param processInstanceId
   * @return
   */
  Set<ProcessInstanceOperateRecordEntity> findDetailsByProcessInstanceId(String processInstanceId);

  /**
   * 根据流程实例ID和节点ID查询操作记录
   * @param processInstanceId
   * @param processNodeId
   * @return
   */
  Set<ProcessInstanceOperateRecordEntity> findByProcessInstanceIdAndProcessNodeId(String processInstanceId, String processNodeId);

  /**
   * 根据任务ID、用户ID、按钮统计
   * @param taskId
   * @param userId
   * @param btns
   * @return
   */
  Long countByTaskIdAndUserIdAndBtns(String taskId, String userId, String... btns);

  /**
   * 根据用户ID和按钮获取操作记录
   * @param taskId
   * @param btns
   * @return
   */
  Set<ProcessInstanceOperateRecordEntity> findByTaskIdAndBtns(String taskId, String... btns);
}
