package com.bizunited.platform.titan.starter.service;

import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.titan.entity.ProcessAssignmentEntity;
import com.bizunited.platform.titan.entity.ProcessInstanceEntity;
import com.bizunited.platform.titan.entity.ProcessTemplateEntity;
import com.bizunited.platform.titan.entity.ProcessTemplateNodeEntity;
import com.bizunited.platform.titan.vo.ProcessImageVo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.security.Principal;
import java.util.Map;
import java.util.Set;

/**
 * 流程实例服务的接口定义
 * @Author: Paul Chan
 * @Date: 2019-05-22 19:16
 */
public interface ProcessInstanceService {
  /**
   * 根据模版ID开启流程
   * @param processTemplateId
   * @param variables
   * @param principal
   * @return
   */
  ProcessInstanceEntity startProcess(String processTemplateId, Map<String, Object> variables, Principal principal);

  /**
   * 初始化会签节点的会签人员变量
   * @param processTemplate
   * @param variables
   * @return
   */
  Map<String, Object> initInstanceMultiVariable(ProcessTemplateEntity processTemplate, Map<String, Object> variables);

  /**
   * 初始化流程实例所有会签节点的会签人员，这个操作主要发生在任务节点回退的时候，如驳回、回退、取回等操作
   * @param processInstance
   */
  void initInstanceMulti(ProcessInstanceEntity processInstance);
  /**
   * 根据流程实例ID查询流程实例
   * @param processInstanceId
   * @return
   */
  ProcessInstanceEntity findByProcessInstanceId(String processInstanceId);
  /**
   * 保存流程实例
   * @param processInstance
   */
  ProcessInstanceEntity save(ProcessInstanceEntity processInstance);
  /**
   * 更新流程实例
   * @param processInstance
   * @param latestAssignment
   * @param latestNode
   * @param currentAssignments
   * @param currentNodes
   * @param state
   * @return
   */
  ProcessInstanceEntity update(ProcessInstanceEntity processInstance, UserEntity latestAssignment, ProcessTemplateNodeEntity latestNode, Set<ProcessAssignmentEntity> currentAssignments, Set<ProcessTemplateNodeEntity> currentNodes, Integer state);
  /**
   * 条件分页查询流程实例
   * @param pageable
   * @param processInstance
   * @param principal
   * @param isApplicant
   * @return
   */
  Page<ProcessInstanceEntity> findByConditions(Pageable pageable, ProcessInstanceEntity processInstance, Principal principal, Boolean isApplicant);
  /**
   * 根据流程实例ID查询详情
   * @param processInstanceId
   * @return
   */
  ProcessInstanceEntity findDetailsByProcessInstanceId(String processInstanceId);
  /**
   * 根据流程实例ID查询流程图片信息，历史节点用绿色高亮现实，
   * 当前活动任务用红色高亮现实，同时返回图片上节点的节点信息和历史操作历史
   * @param processInstanceId
   * @return
   */
  ProcessImageVo findImageInfoByProcessInstanceId(String processInstanceId);

  /**
   * 设置流程变量
   * @param processInstanceId
   * @param variables
   * @return
   */
  Map<String, Object> setProcessVariables(String processInstanceId, Map<String, Object> variables);

  /**
   * 查询流程变量
   * @param processInstanceId
   * @return
   */
  Map<String, Object> findVariablesByProcessInstanceId(String processInstanceId);
}
