package com.bizunited.platform.titan.starter.service;

import com.bizunited.platform.titan.entity.ProcessListenerEntity;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-15 20:12
 * @Description: 流程监听器服务接口定义
 */
public interface ProcessListenerService {

  /**
   * 条件查询流程监听器
   * @param processListener
   * @param pageable
   * @return
   */
  Page<ProcessListenerEntity> findByConditions(ProcessListenerEntity processListener, Pageable pageable);

  /**
   * 创建流程监听器
   * @param processListener
   * @return
   */
  ProcessListenerEntity create(ProcessListenerEntity processListener);

  /**
   * 更新流程监听器
   * @param processListener
   * @return
   */
  ProcessListenerEntity update(ProcessListenerEntity processListener);

  /**
   * 切换状态
   * @param id
   * @param state
   */
  void handleState(String id, Integer state);

  /**
   * 根据ID查询
   * @param id
   * @return
   */
  ProcessListenerEntity findById(String id);
}
