package com.bizunited.platform.titan.starter.service;

import com.bizunited.platform.titan.entity.ProcessTemplateEntity;
import com.bizunited.platform.titan.entity.ProcessTemplateListenerEntity;

import java.util.List;
import java.util.Set;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-14 14:15
 * @Description: 流程模版监听器的服务接口定义
 */
public interface ProcessTemplateListenerService {


  /**
   * 创建流程模版监听器
   * @param processTemplateEntity
   * @param processTemplateListeners
   */
  void create(ProcessTemplateEntity processTemplateEntity, Set<ProcessTemplateListenerEntity> processTemplateListeners);

  /**
   * 更新流程模版监听器
   * @param processTemplateEntity
   * @param processTemplateListeners
   */
  void update(ProcessTemplateEntity processTemplateEntity, Set<ProcessTemplateListenerEntity> processTemplateListeners);

  /**
   * 根据流程模版ID查询详情
   * @param processTemplateId
   * @return
   */
  Set<ProcessTemplateListenerEntity> findDetailsByProcessTemplateId(String processTemplateId);

  /**
   * 根据定义ID、目标节点ID、事件获取监听器
   * @param processDefinitionId
   * @param targetId
   * @param event
   * @return
   */
  List<ProcessTemplateListenerEntity> findDetailsByProcessDefinitionIdAndTargetIdAndEvent(String processDefinitionId, String targetId, String event);

}
