package com.bizunited.platform.titan.starter.service;

import com.bizunited.platform.titan.entity.ProcessTemplateNodeAssignmentEntity;
import com.bizunited.platform.titan.entity.ProcessTemplateNodeEntity;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-13 19:03
 * @Description: 流程节点审批人的服务接口定义
 */
public interface ProcessTemplateNodeAssignmentService {

  /**
   * 创建节点的审批人信息
   * @param node
   * @param assignment
   */
  void create(ProcessTemplateNodeEntity node, ProcessTemplateNodeAssignmentEntity assignment);

  /**
   * 更新节点的审批人信息
   * @param node
   * @param assignment
   */
  void update(ProcessTemplateNodeEntity node, ProcessTemplateNodeAssignmentEntity assignment);

  /**
   * 根据流程定义ID和节点ID获取节点审批人配置
   * @param processDefinitionId
   * @param processNodeId
   * @return
   */
  ProcessTemplateNodeAssignmentEntity findDetailsByProcessDefinitionIdAndProcessNodeId(String processDefinitionId, String processNodeId);
}
