package com.bizunited.platform.titan.starter.service;

import com.bizunited.platform.titan.entity.ProcessTemplateNodePermissionEntity;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.security.Principal;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-21 17:37
 * @Description: 流程模版节点配置服务的接口定义
 */
public interface ProcessTemplateNodePermissionService {

  /**
   * 创建流程节点操作权限
   * @param nodePermission
   * @param principal
   * @return
   */
  ProcessTemplateNodePermissionEntity create(ProcessTemplateNodePermissionEntity nodePermission, Principal principal);

  /**
   * 更新流程节点操作权限
   * @param nodePermission
   * @param principal
   * @return
   */
  ProcessTemplateNodePermissionEntity update(ProcessTemplateNodePermissionEntity nodePermission, Principal principal);

  /**
   * 分页条件查询流程节点操作权限
   * @param nodePermission
   * @param pageable
   * @return
   */
  Page<ProcessTemplateNodePermissionEntity> findByConditions(ProcessTemplateNodePermissionEntity nodePermission, Pageable pageable);

  /**
   * 根据ID查明细
   * @param id
   * @return
   */
  ProcessTemplateNodePermissionEntity findDetailById(String id);
}
