package com.bizunited.platform.titan.starter.service;

import com.bizunited.platform.titan.entity.ProcessTemplateEntity;
import com.bizunited.platform.titan.entity.ProcessTemplateNodeEntity;

import java.util.List;
import java.util.Set;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-13 18:00
 * @Description: 流程节点的服务接口定义
 */
public interface ProcessTemplateNodeService {


  /**
   * 创建流程模版节点信息
   * @param processTemplateEntity
   * @param processTemplateNodes
   */
  void create(ProcessTemplateEntity processTemplateEntity, Set<ProcessTemplateNodeEntity> processTemplateNodes);

  /**
   * 更新流程模版的节点信息
   * @param processTemplateEntity
   * @param processTemplateNodes
   */
  void update(ProcessTemplateEntity processTemplateEntity, Set<ProcessTemplateNodeEntity> processTemplateNodes);

  /**
   * 根据表单ID和流程节点ID查询流程节点
   * @param templateId
   * @param processNodeId
   * @return
   */
  ProcessTemplateNodeEntity findByProcessTemplateIdAndProcessNodeId(String templateId, String processNodeId);

  /**
   * 根据表单ID和流程节点ID查询流程节点详情
   * @param templateId
   * @param processNodeId
   * @return
   */
  ProcessTemplateNodeEntity findDetailByProcessTemplateIdAndProcessNodeId(String templateId, String processNodeId);

  /**
   * 根据流程模版ID查询详情列表
   * @param processTemplateId
   * @return
   */
  Set<ProcessTemplateNodeEntity> findDetailsByProcessTemplateId(String processTemplateId);

  /**
   *  根据流程模版ID和撤销标识查询节点
   * @param processTemplateId
   * @param cancelFlag
   * @return
   */
  List<ProcessTemplateNodeEntity> findByProcessTemplateIdAndCancelFlag(String processTemplateId, boolean cancelFlag);

  /**
   * 获取流程模版的节点
   * @param templateId
   * @return
   */
  List<ProcessTemplateNodeEntity> findByProcessTemplateId(String templateId);
}
