package com.bizunited.platform.titan.starter.service;

import com.bizunited.platform.titan.entity.ProcessTemplateEntity;
import com.bizunited.platform.titan.entity.ProcessTemplatePermissionEntity;

import java.util.Set;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-13 16:59
 * @Description: 流程模版权限的服务接口定义
 */
public interface ProcessTemplatePermissionService {

  /**
   * 创建流程模版权限
   * @param processTemplateEntity
   * @param permission
   */
  void create(ProcessTemplateEntity processTemplateEntity, Set<ProcessTemplatePermissionEntity> permission);


  /**
   * 更新流程模版权限
   * @param processTemplateEntity
   * @param permission
   */
  void update(ProcessTemplateEntity processTemplateEntity, Set<ProcessTemplatePermissionEntity> permission);


  /**
   * 根据模版ID查询权限详情集合
   * @param templateId
   * @return
   */
  Set<ProcessTemplatePermissionEntity> findByProcessTemplateId(String templateId);
}
