package com.bizunited.platform.titan.starter.service;

import com.bizunited.platform.titan.entity.ProcessTemplateEntity;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.security.Principal;
import java.util.List;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-13 10:54
 * @Description: 流程模版的服务接口定义
 */
public interface ProcessTemplateService {


  /**
   * 分页条件查询流程模版数据
   * @param pageable
   * @param processTemplate
   * @return
   */
  Page<ProcessTemplateEntity> findByConditions(Pageable pageable, ProcessTemplateEntity processTemplate);

  /**
   * 创建流程模版
   * @param processTemplateEntity
   * @param principal
   * @param cvertion
   * @return
   */
  ProcessTemplateEntity create(ProcessTemplateEntity processTemplateEntity, Principal principal, int cvertion);

  /**
   * 更新流程模版
   * @param processTemplateEntity
   * @param principal
   * @return
   */
  ProcessTemplateEntity update(ProcessTemplateEntity processTemplateEntity, Principal principal);

  /**
   * 根据模版ID查询模版明细
   * @param id
   * @return
   */
  ProcessTemplateEntity findDetailsById(String id);

  /**
   * 根据流程实例ID查询模版明细
   * @param processInstanceId
   * @return
   */
  ProcessTemplateEntity findDetailsByProcessInstanceId(String processInstanceId);

  /**
   * 升级流程版本,以最新模版为本升级版本，升级版本要求当前无正在编辑的模版
   * @param processTemplate
   * @param principal
   * @return
   */
  ProcessTemplateEntity upgradeVersion(ProcessTemplateEntity processTemplate, Principal principal);

  /**
   * 根据流程key查询流程模版
   * @param processKey
   * @return
   */
  List<ProcessTemplateEntity> findByProcessKey(String processKey);

  /**
   * 发布流程到流程引擎
   * @param id
   * @param principal
   */
  void deploy(String id, Principal principal);

  /**
   * 根据ID删除流程模版
   * @param id
   * @param principal
   */
  void deleteById(String id, Principal principal);

  /**
   * 根据ID查询模版
   * @param id
   * @return
   */
  ProcessTemplateEntity findById(String id);

  /**
   * 分页查询可发起的流程模版
   * @param pageable
   * @param processTemplate
   * @param principal
   * @return
   */
  Page<ProcessTemplateEntity> findStartableByConditions(Pageable pageable, ProcessTemplateEntity processTemplate, Principal principal);

  /**
   * 获取流程结束节点的定义ID
   * @param processTemplate
   * @return
   */
  String getEndActivityId(ProcessTemplateEntity processTemplate);

  /**
   * 获取开始活动和出线
   * @param process
   * @return
   */
  List<String> getStartEventAndOutLine(Process process);

  /**
   * 获取活动节点对象
   * @param processDefinitionId
   * @param taskDefinitionKey
   * @return
   */
  FlowElement findFlowElement(String processDefinitionId, String taskDefinitionKey);

  /**
   * 获取流程xml
   * @param id
   * @return
   */
  String findProcessXmlById(String id);

  /**
   * 根据ID获取流程文件
   * @param id
   * @return
   */
  BpmnModel findBpmnById(String id);

}
