package com.bizunited.platform.titan.starter.service;

import com.bizunited.platform.titan.entity.ProcessVariableEntity;

import java.util.Map;
import java.util.Set;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-21 10:10
 * @Description: 流程变量服务接口定义
 */
public interface ProcessVariableService {


  /**
   * 保存数据源的变量,保存新增的变量，更新已存在的变量，删除保存集合不存在的变量
   * @param sourceId
   * @param variables
   */
  Set<ProcessVariableEntity> save(String sourceId, Set<ProcessVariableEntity> variables);

  /**
   * 根据数据源ID删除变量
   * @param sourceId
   */
  void deleteBySourceId(String sourceId);

  /**
   * 根据数据源ID查询变量
   * @param sourceId
   * @return
   */
  Set<ProcessVariableEntity> findBySourceId(String sourceId);

  /**
   * 根据数据源ID获取变量的map
   * @param targetId
   * @return
   */
  Map<String, Object> getVariablesByTargetId(String targetId);

}
