package com.bizunited.platform.titan.starter.service;

import com.bizunited.platform.core.service.NebulaToolkitService;
import com.bizunited.platform.rbac.server.vo.PositionVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import static com.bizunited.platform.titan.starter.common.Constants.POSITION_PREFIX;

/**
 * 这是一个工具包性质的服务类，主要为了减少基于流程引擎完成的后端业务开发的工作量。
 * @author yinwenjie
 */
public class TitanToolkitService extends NebulaToolkitService {

  /**
   * 获取代理职位编码列表，有position:前缀
   * @param positionVos
   * @return
   */
  public List<String> getAssignmentPositionCodes(Set<PositionVo> positionVos){
    List<String> positionCodes = new ArrayList<>();
    if(!CollectionUtils.isEmpty(positionVos)){
      for (PositionVo positionVo : positionVos) {
        positionCodes.add(StringUtils.join(POSITION_PREFIX, positionVo.getCode()));
      }
    }
    return positionCodes;
  }

}