package com.bizunited.platform.titan.starter.service.internal;

import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.rbac.server.service.PositionService;
import com.bizunited.platform.rbac.server.service.UserService;
import com.bizunited.platform.rbac.server.vo.PositionVo;
import com.bizunited.platform.rbac.server.vo.UserVo;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.util.CollectionUtils;

import java.security.Principal;
import java.util.List;

/**
 * 基础服务
 * @Author: Paul Chan
 * @Date: 2019-05-23 14:20
 */
public class BaseService {

  @Autowired
  protected UserService userService;
  @Autowired
  protected PositionService positionService;
  private static final String ERROR_USER_INFO = "登录人不存在，或登录信息已失效!";

  /**
   * 获取登录用户，未登录或为获取到用户信息时会抛出异常
   * @param principal
   * @return
   */
  public UserEntity getLoginUser(Principal principal) {
    Validate.notNull(principal, "未登录系统");
    String userAccount = principal.getName();
    Validate.notBlank(userAccount, ERROR_USER_INFO);
    UserEntity user = getUserByAccount(principal.getName());
    Validate.notNull(user, ERROR_USER_INFO);
    return user;
  }

  /**
   * 根据用户名获取用户,不会抛异常
   * @param account
   * @return
   */
  public UserEntity getUserByAccount(String account){
    if(StringUtils.isBlank(account)) return null;
    UserVo userVo = userService.findByAccount(account);
    if(userVo == null){
      return null;
    }
    UserEntity user = new UserEntity();
    user.setId(userVo.getId());
    user.setAccount(account);
    user.setUserName(userVo.getUserName());
    return user;
  }


  /**
   * 根据职位编码获取职位信息
   * @param positionCode
   * @return
   */
  public PositionVo findPositionByCode(String positionCode) {
    if(StringUtils.isBlank(positionCode)) return null;
    Page<PositionVo> page = positionService.findByConditions(positionCode, null, null, null);
    if(page != null){
      List<PositionVo> positionVos = page.getContent();
      if(!CollectionUtils.isEmpty(positionVos)){
        return positionVos.get(0);
      }
    }
    return null;
  }
}
