package com.bizunited.platform.titan.starter.service.internal;

import com.bizunited.platform.titan.entity.ProcessCheckRecordEntity;
import com.bizunited.platform.titan.entity.ProcessCheckRecordItemEntity;
import com.bizunited.platform.titan.starter.repository.ProcessCheckRecordItemRepository;
import com.bizunited.platform.titan.starter.service.ProcessCheckRecordItemService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.transaction.Transactional;
import java.util.Date;
import java.util.Set;

/**
 * 流程检测明细服务接口实现
 * @Author: Paul Chan
 * @Date: 2019-06-18 11:59
 */
@Service("ProcessCheckRecordItemServiceImpl")
public class ProcessCheckRecordItemServiceImpl implements ProcessCheckRecordItemService {

  @Autowired
  private ProcessCheckRecordItemRepository processCheckRecordItemRepository;

  /**
   * 检查数据正确性
   * @param items
   */
  private void createValidation(Set<ProcessCheckRecordItemEntity> items){
    if(!CollectionUtils.isEmpty(items)){
      for (ProcessCheckRecordItemEntity item : items) {
        Validate.notBlank(item.getCheckType(), "检测类型不能为空");
        Validate.notBlank(item.getNodeKey(), "节点key不能为空");
        Validate.notBlank(item.getNodeName(), "节点名称不能为空");
        Validate.notBlank(item.getResult(), "检测结果不能为空");
        Validate.notBlank(item.getTaskId(), "任务ID不能为空");
        Validate.notNull(item.getState(), "状态不能为空");
      }
    }
  }

  @Override
  @Transactional
  public Set<ProcessCheckRecordItemEntity> create(ProcessCheckRecordEntity record, Set<ProcessCheckRecordItemEntity> items) {
    Validate.notNull(record, "检测记录不能为空");
    this.createValidation(items);
    if(!CollectionUtils.isEmpty(items)){
      for (ProcessCheckRecordItemEntity item : items) {
        item.setProcessCheckRecord(record);
        item.setCreateTime(new Date());
        processCheckRecordItemRepository.save(item);
      }
    }
    return items;
  }
}
