package com.bizunited.platform.titan.starter.service.internal;

import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.titan.entity.ProcessInstanceEntity;
import com.bizunited.platform.titan.entity.ProcessInstanceMsgEntity;
import com.bizunited.platform.titan.starter.common.enums.TaskOperateBtn;
import com.bizunited.platform.titan.starter.repository.ProcessInstanceMsgRepository;
import com.bizunited.platform.titan.starter.service.ProcessInstanceMsgService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.transaction.Transactional;
import java.security.Principal;
import java.util.Date;
import java.util.List;

/**
 * 流程实例消息服务的接口实现
 * @Author: Paul Chan
 * @Date: 2019-05-23 14:54
 */
@Service("ProcessInstanceMsgServiceImpl")
public class ProcessInstanceMsgServiceImpl extends BaseService implements ProcessInstanceMsgService {

  @Autowired
  private ProcessInstanceMsgRepository processInstanceMsgRepository;

  /**
   * 创建前验证数据
   * @param msg
   */
  private void createValidation(ProcessInstanceMsgEntity msg){
    Validate.notNull(msg, "保存对象不能为空");
    Validate.notBlank(msg.getContent(), "消息内容不能为空");
    Validate.notNull(msg.getProcessInstance(), "流程实例对象不能为空");
    Validate.notBlank(msg.getProcessInstance().getId(), "流程实例ID不能为空");
  }

  @Override
  @Transactional
  public ProcessInstanceMsgEntity create(UserEntity user, ProcessInstanceEntity processInstance, String content, TaskOperateBtn operateBtn) {
    ProcessInstanceMsgEntity msg = new ProcessInstanceMsgEntity();
    msg.setSendUser(user);
    msg.setProcessInstance(processInstance);
    msg.setContent(content);
    msg.setOperation(operateBtn.getBtn());
    msg.setCreateTime(new Date());
    this.createValidation(msg);
    processInstanceMsgRepository.save(msg);
    return msg;
  }

  @Override
  @Transactional
  public ProcessInstanceMsgEntity create(ProcessInstanceMsgEntity msg, Principal principal){
    this.createValidation(msg);
    UserEntity user = super.getLoginUser(principal);
    msg.setSendUser(user);
    msg.setOperation(TaskOperateBtn.BTN_017.getBtn());
    msg.setCreateTime(new Date());
    processInstanceMsgRepository.save(msg);
    return msg;
  }

  @Override
  public List<ProcessInstanceMsgEntity> findByProcessInstanceId(String processInstanceId) {
    if(StringUtils.isBlank(processInstanceId)) return null;
    List<ProcessInstanceMsgEntity> msgs = processInstanceMsgRepository.findByProcessInstanceId(processInstanceId);
    setIgnoreNull(msgs);
    return msgs;
  }

  /**
   * 将忽略的对象设置为null
   * @param msgs
   */
  private void setIgnoreNull(List<ProcessInstanceMsgEntity> msgs){
    if(CollectionUtils.isEmpty(msgs)) return;
    for (ProcessInstanceMsgEntity msg : msgs) {
      msg.setProcessInstance(null);
      msg.setParent(null);
      msg.getSendUser().setGroups(null);
      msg.getSendUser().setOrgs(null);
      msg.getSendUser().setPositions(null);
      msg.getSendUser().setRoles(null);
      setIgnoreNull(msg.getReplyMsgs());
    }
  }


}
