package com.bizunited.platform.titan.starter.service.internal;

import com.bizunited.platform.core.entity.ScriptEntity;
import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.titan.entity.ProcessListenerEntity;
import com.bizunited.platform.titan.entity.ProcessTemplateNodeAssignmentEntity;
import com.bizunited.platform.titan.entity.ProcessTemplateNodeEntity;
import com.bizunited.platform.titan.entity.ProcessVariableEntity;
import com.bizunited.platform.titan.starter.repository.ProcessTemplateNodeAssignmentRepository;
import com.bizunited.platform.titan.starter.service.ProcessListenerService;
import com.bizunited.platform.titan.starter.service.ProcessTemplateNodeAssignmentService;
import com.bizunited.platform.titan.starter.service.ProcessVariableService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;
import java.util.Date;
import java.util.Set;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-13 19:04
 * @Description: 流程模版节点审批人服务的实现
 */
@Service("ProcessTemplateNodeAssignmentServiceImpl")
public class ProcessTemplateNodeAssignmentServiceImpl implements ProcessTemplateNodeAssignmentService {

  @Autowired
  private ProcessTemplateNodeAssignmentRepository processTemplateNodeAssignmentRepository;

  @Autowired
  private ScriptService scriptService;
  @Autowired
  private ProcessVariableService processVariableService;
  @Autowired
  private ProcessListenerService processListenerService;

  @Override
  @Transactional
  public void create(ProcessTemplateNodeEntity node, ProcessTemplateNodeAssignmentEntity assignment) {
    Validate.notNull(node, "流程节点不能为空");
    if(assignment == null) return;
    Validate.isTrue(assignment.getId() == null, "创建审批人不能有ID");
    Validate.notNull(assignment.getType(), "审批人类型不能为空");
    this.validListenerAndScript(assignment);
    assignment.setCreateTime(new Date());
    assignment.setModifyTime(new Date());
    assignment.setProcessTemplateNode(node);
    processTemplateNodeAssignmentRepository.save(assignment);
    Set<ProcessVariableEntity> variables = processVariableService.save(assignment.getId(), assignment.getVariables());
    assignment.setVariables(variables);
    node.setAssignment(assignment);
  }

  /**
   * 验证监听器和脚本对象
   * @param assignment
   */
  private void validListenerAndScript(ProcessTemplateNodeAssignmentEntity assignment){
    if(assignment.getProcessListener() != null){
      ProcessListenerEntity processListener = assignment.getProcessListener();
      Validate.notBlank(processListener.getId(), "关联的监听器ID不能为空");
      processListener = processListenerService.findById(processListener.getId());
      Validate.notNull(processListener, "未找到审批人关联的监听器:%s", processListener.getId());
      assignment.setProcessListener(processListener);
    }
    if(assignment.getScript() != null){
      ScriptEntity script = assignment.getScript();
      Validate.notBlank(script.getId(), "关联的脚本ID不能为空");
      script = scriptService.findById(script.getId());
      Validate.notNull(script, "未找到关联的脚本：%s", script.getId());
      assignment.setScript(script);
    }
  }

  @Override
  @Transactional
  public void update(ProcessTemplateNodeEntity node, ProcessTemplateNodeAssignmentEntity assignment) {
    Validate.notNull(node, "流程节点不能为空");
    ProcessTemplateNodeAssignmentEntity assignmentEntity = processTemplateNodeAssignmentRepository.findByProcessTemplateNodeId(node.getId());
    if(assignmentEntity == null){
      this.create(node, assignment);
      return;
    }
    if(assignment == null){
      processTemplateNodeAssignmentRepository.delete(assignmentEntity);
      return;
    }
    Validate.notNull(assignment.getType(), "审批人类型不能为空");
    this.validListenerAndScript(assignment);
    assignmentEntity.setModifyTime(new Date());
    assignmentEntity.setProcessListener(assignment.getProcessListener());
    assignmentEntity.setScript(assignment.getScript());
    assignmentEntity.setType(assignment.getType());
    processTemplateNodeAssignmentRepository.save(assignmentEntity);
    Set<ProcessVariableEntity> variables = processVariableService.save(assignmentEntity.getId(), assignment.getVariables());
    assignmentEntity.setVariables(variables);
    node.setAssignment(assignmentEntity);
    
  }

  @Override
  public ProcessTemplateNodeAssignmentEntity findDetailsByProcessDefinitionIdAndProcessNodeId(String processDefinitionId, String processNodeId) {
    ProcessTemplateNodeAssignmentEntity assignmentEntity = processTemplateNodeAssignmentRepository.findDetailsByProcessDefinitionIdAndProcessNodeId(processDefinitionId, processNodeId);
    if(assignmentEntity != null){
      Set<ProcessVariableEntity> variables = processVariableService.findBySourceId(assignmentEntity.getId());
      assignmentEntity.setVariables(variables);
    }
    return assignmentEntity;
  }
}
