package com.bizunited.platform.titan.starter.service.internal;

import com.bizunited.platform.titan.entity.ProcessAssignmentEntity;
import com.bizunited.platform.titan.entity.ProcessTemplateNodeEntity;
import com.bizunited.platform.titan.entity.ProcessTemplateNodeMultiEntity;
import com.bizunited.platform.titan.starter.common.enums.MultiType;
import com.bizunited.platform.titan.starter.repository.ProcessTemplateNodeMultiRepository;
import com.bizunited.platform.titan.starter.service.ProcessAssignmentService;
import com.bizunited.platform.titan.starter.service.ProcessTemplateNodeMultiService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;
import java.util.Date;
import java.util.Set;

/**
 * 流程节点会签属性服务实现
 * @Author: Paul Chan
 * @Date: 2019-05-31 10:39
 */
@Service("ProcessTemplateNodeMultiServiceImpl")
public class ProcessTemplateNodeMultiServiceImpl extends BaseService implements ProcessTemplateNodeMultiService {

  @Autowired
  private ProcessTemplateNodeMultiRepository processTemplateNodeMultiRepository;

  @Autowired
  private ProcessAssignmentService processAssignmentService;

  private void saveValidation(ProcessTemplateNodeMultiEntity processTemplateNodeMulti){
    Validate.notNull(processTemplateNodeMulti.getMiType(), "会签类型不能为空");
    if(!processTemplateNodeMulti.getMiType().equals(MultiType.NONE_MULTI.getType())){
      Validate.notNull(processTemplateNodeMulti.getPresetMiAssignments(), "是否预置会签人员不能为空");
      Validate.notBlank(processTemplateNodeMulti.getCompletionCondition(), "会签通过条件不能为空");
      if(processTemplateNodeMulti.getPresetMiAssignments()){
        Validate.notEmpty(processTemplateNodeMulti.getAssignments(), "预置会签人员不能为空");
      }
    }
  }

  @Override
  @Transactional
  public ProcessTemplateNodeMultiEntity save(ProcessTemplateNodeEntity node, ProcessTemplateNodeMultiEntity processTemplateNodeMulti) {
    // 如果保存对象为空则直接返回，具体的数据正确性在部署模版的时候验证
    if(processTemplateNodeMulti == null) return null;
    Validate.notNull(node, "流程节点不能为空");
    saveValidation(processTemplateNodeMulti);
    ProcessTemplateNodeMultiEntity entity = processTemplateNodeMultiRepository.findByTemplateNodeId(node.getId());
    if (entity == null){
      entity = processTemplateNodeMulti;
      entity.setId(null);
      entity.setProcessTemplateNode(node);
      entity.setCreateTime(new Date());
    } else {
      entity.setCompletionCondition(processTemplateNodeMulti.getCompletionCondition());
      entity.setMiType(processTemplateNodeMulti.getMiType());
      entity.setPresetMiAssignments(processTemplateNodeMulti.getPresetMiAssignments());
    }
    entity.setModifyTime(new Date());
    processTemplateNodeMultiRepository.save(entity);
    Set<ProcessAssignmentEntity> assignments = processAssignmentService.save(entity.getId(), processTemplateNodeMulti.getAssignments());
    entity.setAssignments(assignments);
    return entity;
  }
}
