package com.bizunited.platform.titan.starter.service.invoke.handle.request;

import com.bizunited.platform.titan.entity.ProcessVariableEntity;
import org.flowable.variable.api.delegate.VariableScope;
import org.springframework.util.CollectionUtils;

import java.util.Set;

/**
 * 监听器处理抽象类
 * @Author: Paul Chan
 * @Date: 2019-06-17 12:29
 */
public abstract class AbstractListenerHandle {

  /**
   * 设置上下文变量值
   * @param variableScope
   * @param processVariables
   */
  protected void setVariables(VariableScope variableScope, Set<ProcessVariableEntity> processVariables){
    if(!CollectionUtils.isEmpty(processVariables)){
      for (ProcessVariableEntity processVariable : processVariables) {
        variableScope.setVariable(processVariable.getName(), processVariable.getValue());
      }
    }
  }

}
