package com.bizunited.platform.titan.starter.service.invoke.handle.request;

import com.bizunited.platform.core.common.PlatformContext;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.springframework.context.ApplicationContext;

import java.util.Map;

/**
 * 脚本监听器处理抽象类
 * @Author: Paul Chan
 * @Date: 2019-06-17 12:19
 */
public abstract class AbstractScriptListenerHandle extends AbstractListenerHandle {

  protected void putFlowableService(Map<String, Object> params){
    ApplicationContext applicationContext = PlatformContext.getApplicationContext();
    TaskService taskService = applicationContext.getBean(TaskService.class);
    RuntimeService runtimeService = applicationContext.getBean(RuntimeService.class);
    RepositoryService repositoryService = applicationContext.getBean(RepositoryService.class);
    HistoryService historyService = applicationContext.getBean(HistoryService.class);
    params.put("taskService", taskService);
    params.put("runtimeService", runtimeService);
    params.put("repositoryService", repositoryService);
    params.put("historyService", historyService);
  }

}
