package com.bizunited.platform.titan.starter.service.invoke.handle.request;

import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.titan.entity.ProcessListenerEntity;
import com.bizunited.platform.titan.entity.ProcessVariableEntity;
import com.bizunited.platform.titan.starter.common.enums.ProcessListenerExecuteMode;
import org.apache.commons.lang3.Validate;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.ExecutionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Set;

/**
 * 处理事件监听器的原生监听器回调，不处理脚本监听器的回调
 * @Author: Paul Chan
 * @Date: 2019-06-14 13:39
 */
public class ExecutionListenerNotifyHandle extends AbstractListenerHandle implements InvokeRequestHandle {

  private final static Logger LOGGER = LoggerFactory.getLogger(TaskListenerNotifyHandle.class);

  private DelegateExecution execution;
  private ProcessListenerEntity listener;
  private Set<ProcessVariableEntity> variables;

  public ExecutionListenerNotifyHandle(DelegateExecution execution, ProcessListenerEntity listener, Set<ProcessVariableEntity> variables){
    this.execution = execution;
    this.listener = listener;
    this.variables = variables;
  }

  @Override
  public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
    LOGGER.info("开始执行监听器：{}", listener.getName());
    Validate.isTrue(listener.getExecuteMode().equals(ProcessListenerExecuteMode.ORIGIN.getMode()), "TaskListenerNotifyHandle只能处理原生监听器");
    try {
      Class<?> listenerClass = Class.forName(listener.getListenerClass());
      Object obj = listenerClass.newInstance();
      // 设置预置变量到本地变量中
      super.setVariables(execution, variables);
      // 执行执行监听器
      // 执行原生监听器
      Validate.isTrue(obj instanceof ExecutionListener, "执行监听器必须实现org.flowable.engine.delegate.ExecutionListener");
      ExecutionListener executionListener = (ExecutionListener) obj;
      executionListener.notify(execution);
    } catch (Exception e) {
      LOGGER.error(e.getMessage(), e);
      throw new IllegalArgumentException(e.getMessage(), e.getCause());
    }
    LOGGER.info("执行结束监听器：{}", listener.getName());
  }

}
