package com.bizunited.platform.titan.starter.service.invoke.handle.request;

import com.bizunited.platform.core.entity.ScriptEntity;
import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.titan.entity.ProcessVariableEntity;
import org.apache.commons.lang3.Validate;
import org.flowable.engine.delegate.DelegateExecution;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * 处理事件监听器的脚本handle
 * @Author: Paul Chan
 * @Date: 2019-06-14 16:49
 */
public class ExecutionScriptListenerHandle extends AbstractScriptListenerHandle implements InvokeRequestHandle {

  private ScriptEntity script;
  private DelegateExecution execution;
  private ScriptService scriptService;
  private Set<ProcessVariableEntity> variables;

  public ExecutionScriptListenerHandle(ScriptEntity script, DelegateExecution execution, ScriptService scriptService, Set<ProcessVariableEntity> variables){
    this.script = script;
    this.execution = execution;
    this.variables = variables;
    this.scriptService = scriptService;
  }

  @Override
  public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
    Validate.notNull(script, "执行脚本不能为空");
    super.setVariables(execution, variables);
    Map<String, Object> params = new HashMap<>(4);
    params.put("delegateExecution", execution);
    super.putFlowableService(params);
    Map<String, Object> returnResults = this.scriptService.invoke(script.getId(), params);
    if(returnResults != null && !returnResults.isEmpty()) {
      context.setChainParams(returnResults);
    }
    chain.doHandle(context, HandleChain.ChainLogic.CONTINUE);
  }

}
