package com.bizunited.platform.titan.starter.service.invoke.handle.request;

import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.kuiper.entity.InstanceActivityEntity;
import com.bizunited.platform.kuiper.starter.service.InstanceActivityLogService;
import com.bizunited.platform.kuiper.starter.service.InstanceActivityService;
import com.bizunited.platform.titan.entity.ProcessInstanceEntity;
import com.bizunited.platform.titan.starter.common.Constants;
import com.bizunited.platform.titan.starter.common.enums.TaskOperateBtn;
import com.bizunited.platform.titan.starter.service.ProcessInstanceService;
import com.bizunited.platform.titan.starter.service.invoke.model.ProcessInputParamsModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import static com.bizunited.platform.titan.starter.common.Constants.NODE_ID_DEFAULT_START;

/**
 * 处理表单实例数据回滚
 * @Author: Paul Chan
 * @Date: 2019-07-11 14:55
 */
@Component("InstanceActivityRecoveryHandle")
public class InstanceActivityRecoveryHandle implements InvokeRequestHandle {

  private final static Logger LOGGER = LoggerFactory.getLogger(InstanceActivityRecoveryHandle.class);

  @Autowired
  private ProcessInstanceService processInstanceService;
  @Autowired
  private InstanceActivityService instanceActivityService;
  @Autowired
  private InstanceActivityLogService instanceActivityLogService;

  @Override
  public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
    ProcessInputParamsModel model = (ProcessInputParamsModel) context.getChainParam(ProcessInputParamsModel.class.getName());
    Validate.notNull(model , "错误的入参模型对象，请检查!!");
    Validate.notBlank(model.getProcessInstanceId(), "流程实例ID不能为空");
    String activityId;
    TaskOperateBtn btn = Constants.TASK_OPERATION_BTN_MAP.get(model.getBtn());
    Validate.notNull(btn, "不支持的操作：%s", model.getBtn());
    switch (btn){
      case BTN_002:
        activityId = NODE_ID_DEFAULT_START;
        break;
      case BTN_003:
        activityId = model.getTargetActivitiId();
        break;
      case BTN_004:
        activityId = model.getActivityId();
        break;
      default:
        LOGGER.error(String.format("不支持的操作：%s", btn.getBtn()));
        throw new UnsupportedOperationException(String.format("不支持的操作：%s", btn.getBtn()));
    }
    Validate.notBlank(activityId, "任务活动ID不能为空");
    ProcessInstanceEntity processInstance = processInstanceService.findByProcessInstanceId(model.getProcessInstanceId());
    Validate.notNull(processInstance, "未找到流程实例对象");
    String taskCode = StringUtils.join(processInstance.getProcessInstanceId(), activityId);
    InstanceActivityEntity instanceActivity = instanceActivityService.findByInstanceIdAndTaskCode(processInstance.getFormInstanceId(), taskCode);
    Validate.notNull(instanceActivity, "未找到对应的表单实例活动对象");
    instanceActivityLogService.recoveryByInstanceActivityId(instanceActivity.getId());
  }

}
